from jinja2 import Environment, FileSystemLoader
import yaml

ENV = Environment(loader=FileSystemLoader('.'))

def get_interface_speed(interface_name):
    """ get_interface_speed zwraca domyslna wartosc przepustowosci w Mb/s dla danego
        interfejsu sieciowego dzieki sprawdzeniu obecnosci odpowiedniego slowa
        kluczowego w jego nazwie
    """

    if 'gigabit' in interface_name.lower():
        return 1000
    if 'fast' in interface_name.lower():
        return 100

ENV.filters['get_interface_speed'] = get_interface_speed
template = ENV.get_template("templatestuff/template.j2")

with open("templatestuff/data.yml") as f:
	interfaces = yaml.load(f)
print(template.render(interface_list=interfaces))